/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PIFrameDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PIHSCSysClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;

public class PISystemPasswordChange {
    private static final int NUM_VALID_PARMS = 5;
    private PrintStream _out;
    private boolean _writeStatus;
    private HashMap _validParms = new HashMap(11, 0.5f);
    private String _managedSystem;
    private String _frame;
    private String _pwType;
    private short _pwTypeShort;
    private String _currPw;
    private String _newPw;
    private boolean _promptForCurrPw;
    private boolean _promptForNewPw;
    private boolean _platPasswd = false;
    private PIHSCCECClient _cecClient = null;
    private PIHSCFrameClient _frameClient = null;
    private static final short PLATFORM_PASSWD = 1;
    private static final short ASM_GENERAL_PASSWD = 2;
    private static final short ASM_ADMIN_PASSWD = 3;
    private static final short PLAT_AUTH_PASSWD = 4;
    private final short ASM_GENERAL_PASSWD_BIT = (short)13;
    private final short ASM_ADMIN_PASSWD_BIT = (short)14;
    private final short PLATFORM_PASSWD_BIT = (short)15;
    private boolean noCurrPWGiven = false;

    private PISystemPasswordChange(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this._frameClient = pIHSCFrameClient;
        this._cecClient = pIHSCCECClient;
        this._out = printStream;
        this._writeStatus = bl;
        this._currPw = "$$Not$$Set$$";
        this._promptForCurrPw = true;
        this._promptForNewPw = true;
        this._validParms.put("-m", null);
        this._validParms.put("--passwd", null);
        this._validParms.put("-t", null);
        this._validParms.put("--newpasswd", null);
        this._validParms.put("-e", null);
    }

    private void mapPwTypeToShort() {
        if ("access".equals(this._pwType)) {
            this._pwTypeShort = 1;
        } else if ("general".equals(this._pwType)) {
            this._pwTypeShort = (short)2;
        } else if ("admin".equals(this._pwType)) {
            this._pwTypeShort = (short)3;
        } else if ("platform".equals(this._pwType)) {
            this._pwTypeShort = (short)4;
        }
    }

    private PIHSCSysClient createSysClient() throws PIHscClientException {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string, null);
        PIHSCSysClient pIHSCSysClient = null;
        if (this._cecClient != null) {
            pIHSCSysClient = pIHSCClientObjectFactory.createSysClient(this._managedSystem, false, 0);
        } else if (this._frameClient != null) {
            pIHSCSysClient = pIHSCClientObjectFactory.createSysClient(this._frame, true, 1);
        }
        if (null == pIHSCSysClient) {
            if (this._cecClient == null) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8002", null, null);
            }
            if (this._frameClient == null) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8001", null, null);
            }
            return null;
        }
        return pIHSCSysClient;
    }

    private int doPasswordChange() throws PIHscClientException {
        int n;
        Object object;
        Object object2;
        int n2 = 0;
        String string = "";
        this.mapPwTypeToShort();
        if (this._managedSystem != null) {
            this._managedSystem = this.mapToMTMS();
        }
        if (this._frame != null) {
            this._frame = this.mapToFrameMTMS();
        }
        if (this._managedSystem != null && this.isGenesisCase() && this._pwTypeShort == 1) {
            this._promptForCurrPw = false;
        }
        if (this._frame != null && !this.isGenesisCase() && this._pwTypeShort == 1 && (object2 = this._frameClient.getFrameDataBean((String[])(object = new String[]{"state"}))) != null && 241 == (n = ((PIFrameDataBean)object2).getState().intValue())) {
            this._platPasswd = true;
        }
        if ((this._frame != null && this.isGenesisCase() || this._frame != null && this._platPasswd) && this._pwTypeShort == 1) {
            this._promptForCurrPw = false;
            this._currPw = "$$Not$$Set$$";
        }
        if (this._frame != null && this._pwTypeShort == 4) {
            this._promptForCurrPw = false;
            this._currPw = "$$Not$$Set$$";
        }
        if ((this._promptForCurrPw || this._promptForNewPw) && this.promptForPasswds() != 0) {
            return 1;
        }
        if (this._currPw != null && this._currPw.length() == 0) {
            this._currPw = "$$Not$$Set$$";
        }
        object = null;
        try {
            object2 = this.createSysClient();
            if (object2 != null) {
                n = object2.getFrameState() ? 1 : 0;
                if (n == 0) {
                    throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "3084", null, null);
                }
                object = this._pwTypeShort == 4 || this._platPasswd ? object2.platformPassword(this._newPw) : object2.setPassword(this._pwTypeShort, this._currPw, this._newPw);
            }
            if (object != null) {
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)object.get("returnCode");
                int n3 = unsignedInt16.intValue();
                String string2 = null;
                if (n3 == 38) {
                    string2 = "PIHscCmdLineBundle";
                    PIHscClientException pIHscClientException = new PIHscClientException("233B", string2, "USER_BAD_OLD_PASSWORD", null, null);
                    System.out.println(pIHscClientException.getMessage());
                    n2 = 1;
                } else if (n3 == 515) {
                    string2 = "CecNoConnSrcBundle";
                    String[] stringArray = new String[1];
                    switch (this._pwTypeShort) {
                        case 1: {
                            stringArray[0] = "HMC Access";
                            break;
                        }
                        case 2: {
                            stringArray[0] = "ASM General";
                            break;
                        }
                        case 3: {
                            stringArray[0] = "ASM Administrator";
                            break;
                        }
                        default: {
                            stringArray[0] = "unknown";
                        }
                    }
                    PIHscClientException pIHscClientException = new PIHscClientException("0240", string2, "0240", stringArray, null);
                    System.out.println(pIHscClientException.getMessage());
                    n2 = 1;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n2;
    }

    private int promptForPasswds() {
        int n = 0;
        String string = "";
        try {
            EExecResult eExecResult;
            String string2 = System.getProperty("HMCtty.name");
            String string3 = null;
            String string4 = null;
            boolean bl = false;
            if (string2 != null && string2 != "") {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string2));
                string3 = "stty --file=" + string2 + " " + eExecResult.stdout;
                string4 = "stty --file=" + string2 + " -echo";
                bl = true;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            if (this._promptForCurrPw) {
                System.out.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ENTER_CURR_PASSWORD"));
                if (bl) {
                    eExecResult = EExec.Exec(string4);
                }
                this._currPw = bufferedReader.readLine().trim();
            }
            if (this._promptForNewPw) {
                System.out.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ENTER_NEW_PASSWORD"));
                if (bl) {
                    eExecResult = EExec.Exec(string4);
                }
                this._newPw = bufferedReader.readLine().trim();
                if (bl) {
                    eExecResult = EExec.Exec((String)string3);
                }
                System.out.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "REENTER_NEW_PASSWORD"));
                if (bl) {
                    eExecResult = EExec.Exec(string4);
                }
                if (!this._newPw.equals(string = bufferedReader.readLine().trim())) {
                    System.out.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "USER_BAD_PASSWORD"));
                    n = 1;
                }
            }
            if (bl) {
                eExecResult = EExec.Exec(string3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private int performCommand() throws PIHscClientException {
        int n = 0;
        this.checkParameters();
        if (this.doPasswordChange() != 0) {
            n = 1;
        }
        if (this._writeStatus) {
            this._writeStatus = false;
            if (n == 0) {
                this._out.print('\u0000');
            } else {
                this._out.print('\u0001');
            }
        }
        return n;
    }

    private boolean validPwType(String string) {
        boolean bl = false;
        if (string == null) {
            bl = false;
        } else if ("access".equals(string) || "general".equals(string) || "admin".equals(string) || "platform".equals(string)) {
            bl = true;
        }
        return bl;
    }

    private String mapToMTMS() {
        String string = this._managedSystem;
        String string2 = null;
        if (string == null) {
            return null;
        }
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CIMObjectPath cIMObjectPath;
            CIMValue cIMValue;
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscS1_0");
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            Enumeration enumeration = PIHscUtil.getCIMEnumInstances(string2, cIMObjectPath2, true);
            String string3 = null;
            while (enumeration != null && enumeration.hasMoreElements() && !this._managedSystem.equals(string3 = (String)(cIMValue = PIHscUtil.getCIMAttribute(string2, cIMObjectPath = (CIMObjectPath)enumeration.nextElement(), "Name")).getValue())) {
                cIMValue = PIHscUtil.getCIMAttribute(string2, cIMObjectPath, "UserDefinedName");
                String string4 = (String)cIMValue.getValue();
                if (!this._managedSystem.equals(string4)) continue;
                string = string3;
                break;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    private String mapToFrameMTMS() {
        String string = this._frame;
        String string2 = null;
        if (string == null) {
            return null;
        }
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CIMObjectPath cIMObjectPath;
            CIMValue cIMValue;
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscS1_0");
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Frame"));
            Enumeration enumeration = PIHscUtil.getCIMEnumInstances(string2, cIMObjectPath2, true);
            String string3 = null;
            while (enumeration != null && enumeration.hasMoreElements() && !this._frame.equals(string3 = (String)(cIMValue = PIHscUtil.getCIMAttribute(string2, cIMObjectPath = (CIMObjectPath)enumeration.nextElement(), "Name")).getValue())) {
                cIMValue = PIHscUtil.getCIMAttribute(string2, cIMObjectPath, "UserDefinedName");
                String string4 = (String)cIMValue.getValue();
                if (!this._frame.equals(string4)) continue;
                string = string3;
                break;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        return string;
    }

    private boolean isGenesisCase() throws PIHscClientException {
        boolean bl = false;
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CIMObjectPath cIMObjectPath = null;
        if (this._managedSystem != null) {
            cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscS1_0");
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath.addKey("Name", new CIMValue((Object)this._managedSystem));
        } else if (this._frame != null) {
            cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscS1_0");
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Frame"));
            cIMObjectPath.addKey("Name", new CIMValue((Object)this._frame));
        }
        UnsignedInt16 unsignedInt16 = null;
        try {
            CIMInstance cIMInstance = PIHscUtil.getCIMInstance(string, cIMObjectPath, false);
            if (this._managedSystem != null) {
                unsignedInt16 = (UnsignedInt16)PIHscUtil.getCIMAttrValue(cIMInstance, "PasswordStatus");
            } else if (this._frame != null) {
                unsignedInt16 = (UnsignedInt16)PIHscUtil.getCIMAttrValue(cIMInstance, "PasswordStatus");
            }
        }
        catch (Throwable throwable) {
            throw new PIHscClientException("8002", "HSCExceptionBundle", "8002");
        }
        if (unsignedInt16 == null) {
            return bl;
        }
        short s = unsignedInt16.shortValue();
        byte[] byArray = ByteUtilities.shortToByteArray(s);
        BitSet bitSet = ByteUtilities.byteArrayToBitSet(byArray);
        switch (this._pwTypeShort) {
            case 1: {
                bl = bitSet.get(15);
                break;
            }
            case 2: {
                bl = bitSet.get(13);
                break;
            }
            case 3: {
                bl = bitSet.get(14);
                break;
            }
        }
        return bl;
    }

    private void checkParameters() throws PIHscClientException {
        if (this._pwType == null || this._pwType.length() < 1 || !this.validPwType(this._pwType)) {
            String[] stringArray = new String[]{"-t"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this._currPw != null) {
            this._promptForCurrPw = false;
        }
        if (this._newPw != null) {
            if (this._newPw.length() < 1) {
                String[] stringArray = new String[]{"--newpasswd"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            this._promptForNewPw = false;
        }
    }

    private boolean emptyCurrPwGiven(HashMap hashMap) {
        return false;
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this._managedSystem = (String)hashMap.get("-m");
        this._pwType = (String)hashMap.get("-t");
        this._currPw = (String)hashMap.get("--passwd");
        this._newPw = (String)hashMap.get("--newpasswd");
        this._frame = (String)hashMap.get("-e");
        if (this.emptyCurrPwGiven(hashMap)) {
            this.noCurrPWGiven = true;
        }
        if (this._managedSystem != null && this._frame != null) {
            String[] stringArray = new String[]{"-e, -m"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHSYSPWD_HELP_GA3"));
    }

    public static int callCommandFromRouter(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PISystemPasswordChange pISystemPasswordChange = new PISystemPasswordChange(pIHSCFrameClient, pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pISystemPasswordChange._validParms);
            pISystemPasswordChange.mapParameters(hashMap);
            n = pISystemPasswordChange.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            printStream.println(pIHscClientException.getMessage());
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

